#version 330
#extension GL_EXT_gpu_shader4 : enable
//Bouncing torusMod01.fsh by gyabo
//https://www.shadertoy.com/view/4dS3zd
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


vec2 rot(vec2 p, float r)
{
	return vec2(
		cos(r) * p.x - sin(r) * p.y,
		sin(r) * p.x + cos(r) * p.y);
}

//https://www.cl.cam.ac.uk/teaching/1999/AGraphHCI/SMAG/node2.html
float tr(vec3 p, float m)
{
	float R = m * 1.0;
	float r = m * 0.33;
	vec2  g = vec2(length(p.xy) - R * R, p.z);
	return length(g) - (r * r);
}

float scene(vec3 p, float tm)
{
	float k = 1.05 + dot(p, vec3(0, -1, 0));
	p.xz = mod(p.xz, 6.0) - 3.0;
	p.y += abs(sin(0.75 * tm * 3.141592)) * 1.5;
	
	//1st
	vec3 w = p;
	w.zx = rot(w.zx, tm * 1.5);
	w.yz = rot(w.yz, tm * 1.4);
	float h0 = min(k, min(tr(w, 1.0), min(tr(w.zxy, 0.9), tr(w.yzx, 0.8))));
	
	//2nd
	w = p;
	w.zx = rot(w.zx, -tm * 1.4);
	w.yz = rot(w.yz, -tm * 1.5);
	float h1 = min(k, min(tr(w, 0.7), min(tr(w.zxy, 0.6), tr(w.yzx, 0.5))));
	return min(h0, h1);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
	float tm = iTime;
	vec2 uv  = -1.0 + 2.0 * ( gl_FragCoord.xy / iResolution.xy );
	vec3 pos = vec3(0, -2.0, -2.0 +  (iMouse.x / iResolution.x) * 2.0);
	vec3 dir = normalize(vec3(uv * vec2(1.25, -1.0), 1.0));
	dir.yz = rot(dir.yz, -0.7);
	dir.xz = rot(dir.xz, tm * 0.1 +  (iMouse.x / iResolution.x) * 2.0);
	float t = 0.0;
	
	//Inter
    for(int i = 0; i < 100; i++) {
        float tt = scene(dir * t + pos, tm);
        if(tt < 0.005) break;
        t += tt;
    }
	
	//Shadow
	vec3  ip = pos + dir * t * 0.995;
	vec3  L  = normalize(vec3(3, -5, -4));//3, -5, -4
	float s  = 0.0;
	for(int i = 0; i < 10; i++)	s += scene(s * L + ip, tm);
	
	//merge
	s *= 0.333;
	vec4  tcol = texture2D(iChannel0, ip.xz * 0.25 + vec2(0, tm * 0.5));
	if(ip.y < 1.0) tcol = vec4(0.717);
	tcol = 0.09 * vec4(vec3(2.5, 3.0, 0.33 + t * 0.55) * s, 1.0) * tcol.xyzz;
	gl_FragColor = sqrt(tcol) * vec4(1.7 - dot(uv, uv));
}




